% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_query_save.R
\name{save_as_geopackage}
\alias{save_as_geopackage}
\title{Save as geopackage}
\usage{
save_as_geopackage(sf, layer_name, file_name = NULL, filepath = NULL)
}
\arguments{
\item{sf}{A \code{tibble} or a list of \code{tibble} objects.}

\item{layer_name}{A string.}

\item{file_name}{A string.}

\item{filepath}{A string.}
}
\value{
A \code{tibble} or a list of \code{tibble} objects.
}
\description{
Save the result of a geoquery in a geopackage. The result can be a layer in
the form of a flat table or a list consisting of a layer and a description
table of the variables.
}
\examples{
library(starschemar)

gms <- geomultistar(ms = ms_mrs, geodimension = "where") |>
  define_geoattribute(
    attribute = "city",
    from_layer = usa_cities,
    by = c("city" = "city", "state" = "state")
  )  |>
  define_geoattribute(
    attribute = "state",
    from_layer = usa_states,
    by = c("state" = "state")
  ) |>
  define_geoattribute(attribute = "region",
                      from_attribute = "state") |>
  define_geoattribute(attribute = "all_where",
                      from_layer = usa_nation)

gdq <- dimensional_query(gms) |>
  select_dimension(name = "where",
                   attributes = c("state", "city")) |>
  select_dimension(name = "when",
                   attributes = c("when_happened_year", "when_happened_week")) |>
  select_fact(
    name = "mrs_age",
    measures = c("n_deaths")
  ) |>
  select_fact(name = "mrs_cause",
              measures = c("pneumonia_and_influenza_deaths", "other_deaths")) |>
  filter_dimension(name = "when", when_happened_week <= "03") |>
  filter_dimension(name = "where", state == "MA")

sf <- gdq |>
  run_geoquery(wider = TRUE)
\donttest{
save_as_geopackage(sf, "city", filepath = tempdir())
}
}
