% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNOpenAPIManager.R
\docType{class}
\name{GNOpenAPIManager}
\alias{GNOpenAPIManager}
\title{GNOpenAPIManager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for communication with
the REST API of a GeoNetwork instance using the legacy API.
}
\description{
GNOpenAPIManager
}
\section{Abstract Methods}{

\describe{
 \item{\code{new(url, user, pwd, version, logger, keyring_backend)}}{
   This method is used to instantiate a \code{GNOpenAPIManager} with the \code{url} of the
   GeoNetwork and credentials to authenticate (\code{user}/\code{pwd}).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the Geonetwork password/token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
 }
 \item{\code{logger(type, text)}}{
   Basic logger to report geonapi logs. Used internally
 }
 \item{\code{INFO(text)}}{
   Logger to report information. Used internally
 }
 \item{\code{WARN(text)}}{
   Logger to report warnings. Used internally
 }
 \item{\code{ERROR(text)}}{
   Logger to report errors. Used internally
 }
 \item{\code{getUrl()}}{
   Get the authentication URL
 }
 \item{\code{getLang()}}{
   Get the service lang
 }
}
}

\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, version, logger, keyring_backend)}}{
   This method is used to instantiate a \code{GNOpenAPIManager} with the \code{url} of the
   GeoNetwork and credentials to authenticate (\code{user}/\code{pwd}).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the Geonetwork password/token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
   
 }
 \item{\code{login(user, pwd)}}{
   This methods attempts a connection to GeoNetwork REST API. User internally
   during initialization of \code{GNLegacyAPIManager}.
 }
 \item{\code{getGroups()}}{
   Retrieves the list of user groups available in Geonetwork
 }
 \item{\code{getTags()}}{
   Retrieves the list of tags (categories) available in Geonetwork
 }
 \item{\code{getCategories()}}{
   Same as \code{getTags()}
 }
 \item{\code{getMetadataByUUID(uuid)}}{
   Get a metadata by UUID. Returns an object of class \code{ISOMetadata} (ISO 19115)
   or \code{ISOFeatureCatalogue} (ISO 19110) (from \pkg{geometa} package)
 }
 \item{\code{insertRecord(xml, file, geometa, metadataType, uuidProcessing, 
                            group, category, rejectIfInvalid, publishToAll,
                            transformWith, schema, extra, 
                            geometa_validate, geometa_inspire)}}{
   Inserts a record by file, XML object or \pkg{geometa} object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}. 
   Extra parameters related to \pkg{geometa} objects: \code{geometa_validate} (TRUE by default) and \code{geometa_inspire} 
   (FALSE by default) can be used to perform ISO and INSPIRE validation respectively.
 }
 \item{\code{insertMetadata(xml, file, geometa, metadataType, uuidProcessing, 
                            group, category, rejectIfInvalid, publishToAll,
                            transformWith, schema, extra, 
                            geometa_validate, geometa_inspire)}}{
   Inserts a metadata by file, XML object or \pkg{geometa} object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}. 
   Extra parameters related to \pkg{geometa} objects: \code{geometa_validate} (TRUE by default) and \code{geometa_inspire} 
   (FALSE by default) can be used to perform ISO and INSPIRE validation respectively.
 }
 \item{\code{updateMetadata(xml, file, geometa, metadataType, 
                            group, category, rejectIfInvalid, publishToAll,
                            transformWith, schema, extra, 
                            geometa_validate, geometa_inspire)}}{
   Updates a metadata by file, XML object or \pkg{geometa} object of class
   'ISOMetadata' or 'ISOFeatureCatalogue'. Extra parameters \code{geometa_validate} (TRUE 
   by default) and \code{geometa_inspire} (FALSE by default) can be used with geometa objects 
   for perform ISO and INSPIRE validation respectively.
 }
 \item{\code{deleteMetadata(id, withBackup)}}{
   Deletes a metadata
 }
}
}

\examples{
\dontrun{
   GNOpenAPIManager$new("http://localhost:8080/geonetwork", "admin", "geonetwork", "4.0.5")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
