% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as_lpp}
\alias{as_lpp}
\alias{as_lpp.gnpp}
\title{Transmute to Point Pattern on a Linear Network}
\usage{
as_lpp(x, ...)

\method{as_lpp}{gnpp}(x, ...)
}
\arguments{
\item{x}{An object of class \code{gnpp}.}

\item{...}{Other arguments.}
}
\value{
A point pattern on a linear network, an object of class \code{lpp}.
}
\description{
\code{as_lpp} transmutes an existing object into a point pattern on a
geometric network, an object of class \code{lpp}.
}
\examples{
library(spatstat.data)
library(spatstat.linnet)

x <- as_lpp(montgomery)
plot(x)

L <- chicago
X <- as_gnpp(chicago, spatstat = TRUE)
x <- as_lpp(X)
# TRUE
all.equal(x, L)
}
\author{
Marc Schneble \email{marc.schneble@stat.uni-muenchen.de}
}
