% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{geo_distance}
\alias{geo_distance}
\title{Calculate distance between two GeoJSON points}
\usage{
geo_distance(from, to, units = "kilometers")
}
\arguments{
\item{from}{Origin point}

\item{to}{Destination point}

\item{units}{(character) Can be degrees, radians, miles, or
kilometers (default)}
}
\value{
Single numeric value
}
\description{
Calculate distance between two GeoJSON points
}
\examples{
point1 <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#f00"
   },
   "geometry": {
      "type": "Point",
      "coordinates": [-75.343, 39.984]
   }
}'

point2 <- '{
  "type": "Feature",
  "properties": {
     "marker-color": "#0f0"
   },
   "geometry": {
      "type": "Point",
      "coordinates": [-75.534, 39.123]
    }
}'

geo_distance(point1, point2)
geo_distance(point1, point2, units = "miles")
geo_distance(point1, point2, units = "degrees")
geo_distance(point1, point2, units = "radians")

pt1 <- '{
  "type": "Feature",
  "geometry": {
    "type": "Point",
    "coordinates": [
       0.5,
       0.5
     ]
   }
}'

pt2 <- '{
  "type": "Feature",
  "geometry": {
    "type": "Point",
    "coordinates": [2, 2]
   }
}'

geo_distance(pt1, pt2, units = "miles")
}
