% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-make.R
\name{geos_empty}
\alias{geos_empty}
\alias{as_geos_type_id}
\alias{as_geos_type_id.default}
\alias{as_geos_type_id.character}
\alias{as_geos_type_id.numeric}
\title{Create empty geometries}
\usage{
geos_empty(type_id = "geometrycollection", crs = wk::wk_crs_inherit())

as_geos_type_id(type_id)

\method{as_geos_type_id}{default}(type_id)

\method{as_geos_type_id}{character}(type_id)

\method{as_geos_type_id}{numeric}(type_id)
}
\arguments{
\item{type_id}{The numeric type identifier for which an
empty should be returned, an object from which
one can be extracted using \code{\link[=as_geos_type_id]{as_geos_type_id()}}
(default to calling \code{\link[=geos_type_id]{geos_type_id()}}). This is most
usefully a character vector with the geometry type
(e.g., point, linestring, polygon).}

\item{crs}{An object that can be interpreted as a CRS}
}
\value{
A \link[=as_geos_geometry]{GEOS geometry vector}.
}
\description{
Create empty geometries
}
\examples{
geos_empty(c("point", "linestring", "polygon"))
geos_empty(1:7)
geos_empty(geos_read_wkt(c("POINT (0 1)", "LINESTRING (0 0, 1 1)")))

}
