% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-basic-strtree.R
\name{geos_basic_strtree}
\alias{geos_basic_strtree}
\alias{geos_basic_strtree_size}
\alias{geos_basic_strtree_finalized}
\alias{geos_basic_strtree_insert}
\alias{geos_basic_strtree_query}
\alias{geos_basic_strtree_query_filtered}
\title{Create a basic GEOS STRTree}
\usage{
geos_basic_strtree(items = NULL, node_capacity = 10L)

geos_basic_strtree_size(tree)

geos_basic_strtree_finalized(tree)

geos_basic_strtree_insert(tree, items)

geos_basic_strtree_query(tree, query, limit = NA, fill = FALSE)

geos_basic_strtree_query_filtered(
  tree,
  query,
  tree_geom,
  fun,
  ...,
  .chunk_size = 65536
)
}
\arguments{
\item{items}{Items to add to the tree index}

\item{node_capacity}{The maximum number of child nodes that a node may have.
The minimum recommended capacity value is 4. If unsure, use a
default node capacity of 10.}

\item{tree}{A \code{\link[=geos_basic_strtree]{geos_basic_strtree()}}}

\item{query}{Items with which to query the tree}

\item{limit}{The maximum number of matches in the tree to return}

\item{fill}{If \code{TRUE}, always returns \code{limit} matches per item in \code{query}
padded with \code{NA} if fewer than \code{limit} matches are found.}

\item{tree_geom}{A vctr coercible to \code{\link[=geos_geometry]{geos_geometry()}} whose indices
align with \code{tree}.}

\item{fun}{A vectorized binary predicate (e.g. \code{\link[=geos_intersects]{geos_intersects()}}) that
will be called with the tree geometry, the query geometry and any \code{...}
args passed.}

\item{...}{Passed to \code{fun}.}

\item{.chunk_size}{The approximate number of comparisons to pass to \code{fun}.}
}
\value{
A geos_basic_strtree object
}
\description{
An experimental alternative to the \code{\link[=geos_strtree]{geos_strtree()}} that provides a more
flexible interface and potentially faster spatial joins. Notably,
\code{\link[=geos_basic_strtree_insert]{geos_basic_strtree_insert()}} uses \code{\link[wk:wk_bbox]{wk::wk_envelope()}} instead of
\code{\link[=as_geos_geometry]{as_geos_geometry()}} and does not keep the underlying geometry in memory.
For object types like \code{\link[wk:xy]{wk::xy()}} with an optimized \code{\link[wk:wk_bbox]{wk::wk_envelope()}}
method, this is very efficient.
}
\examples{
tree <- geos_basic_strtree(wk::xy(1:5, 1:5))
geos_basic_strtree_size(tree)
(geos_basic_strtree_insert(tree, wk::xy(6:10, 6:10)))
geos_basic_strtree_query(tree, as_geos_geometry("LINESTRING (3 0, 0 3)"))

}
