% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSResource.R
\docType{class}
\name{GSResource}
\alias{GSResource}
\title{A GeoServer abstract resource}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer resource
}
\description{
This class models an abstract GeoServer resource. This class is
used internally for modelling instances of class \code{GSFeatureType} or
\code{GSCoverage}
}
\details{
Geoserver REST API Resource
}
\section{Fields}{

\describe{
\item{\code{nativeBoundingBox}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(rootName, xml)}}{
   This method is used to instantiate a GSResource
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSResource from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSResource to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
 \item{\code{setEnabled(enabled)}}{
   Sets if the resource is enabled or not in GeoServer
 }
 \item{\code{setName(name)}}{
   Sets the resource name
 }
 \item{\code{setNativeName(nativeName)}}{
   Sets the resource native name
 }
 \item{\code{setTitle(title)}}{
   Sets the resource title
 }
 \item{\code{setDescription(description)}}{
   Sets the resource description
 }
 \item{\code{setAbstract(abstract)}}{
   Sets the resource abstract
 }
 \item{\code{setKeywords(keywords)}}{
   Sets a list of keywords
 }
 \item{\code{addKeyword(keyword)}}{
   Sets a keyword. Returns TRUE if set, FALSE otherwise
 }
 \item{\code{delKeyword(keyword)}}{
   Deletes a keyword. Returns TRUE if deleted, FALSE otherwise
 }
 \item{\code{setMetadataLinks(metadataLinks)}}{
   Sets a list of \code{GSMetadataLinks}
 }
 \item{\code{addMetadataLink(metadataLink)}}{
   Adds a metadataLink
 }
 \item{\code{delMetadataLink(metadataLink)}}{
   Deletes a metadataLink
 }
 \item{\code{setNativeCRS(nativeCRS)}}{
   Sets the resource nativeCRS
 }
 \item{\code{setSrs(srs)}}{
   Sets the resource srs
 }
 \item{\code{setNativeBoundingBox(minx, miny, maxx, maxy, bbox, crs)}}{
   Sets the resource nativeBoundingBox. Either from coordinates or from
   a \code{bbox} object (matrix).
 }
 \item{\code{setLatLonBoundingBox(minx, miny, maxx, maxy, bbox, crs)}}{
   Sets the resource latLonBoundingBox. Either from coordinates or from
   a \code{bbox} object (matrix).
 }
 \item{\code{setProjectionPolicy(policy)}}{
   Sets the resource projection policy
 }
}
}

\examples{
res <- GSResource$new(rootName = "featureType")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{resource}
\keyword{rest}
