% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_midpoint.R
\name{geo_midpoint}
\alias{geo_midpoint}
\title{Point of Equidistance to Up to Three Longitude, Latitude Points}
\usage{
geo_midpoint(coordinate_matrix, alternative = FALSE)
}
\arguments{
\item{coordinate_matrix}{A matrix of latitude and longitude columns and up to three rows}

\item{alternative}{Whether to use alternative line creation method. Could be needed when nearly inverse angles cause intersections to be ambiguous.}
}
\value{
Returns a vector of length 2 containing a latitude and longitude point.
}
\description{
Generates a latitude and longitude point that is equidistant to up to three latitude and longitude points
}
\examples{

# Load required packages
require(mapview)
require(sp)

# Create sample geo dataset
sample_coord <-
   matrix(
        c(
            sample(327131680:419648450, 3) / 10000000,
            sample(-1147301410:-1241938690, 3) / 10000000
        ),
        ncol = 2
    )

# Generate circumcenter and radius
gmp <- geo_midpoint(sample_coord)

# Find distance to circumcenter
radius <- geo_point_dist(rbind(sample_coord[1, ], gmp))

# Create 80 sided polygon based on gmp's center and radius
gmp_poly <- geo_surround_poly(gmp, radius, 80)

# Join all the points into a single matrix
bound_poly <- rbind(sample_coord, as.vector(gmp), gmp_poly)

# Create SpacialPoints object and pass to mapview for visualization
mapview(
    SpatialPoints(
        bound_poly[,c(2, 1)],
        proj4string = CRS("+proj=longlat +datum=WGS84")
    )
)


}
\seealso{
\code{\link{geo_sed}} \code{\link{geo_point_dist}}
}
\author{
Shant Sukljian
}
\keyword{circle}
\keyword{disk}
\keyword{enclosing}
\keyword{geo}
\keyword{latitude}
\keyword{longitude}
\keyword{sed}
\keyword{smallest}
