% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stereonet.R
\name{stereonet}
\alias{stereonet}
\title{stereonet}
\usage{
stereonet(
  trd,
  plg,
  coneAngle = rep(10, length(trd)),
  option = 1,
  wulff = TRUE,
  add = FALSE,
  degrees = FALSE,
  show.grid = TRUE,
  grid.col = "grey50",
  tl = 0.05,
  type = "p",
  labels = 1:length(trd),
  ...
)
}
\arguments{
\item{trd}{trend angle, in degrees, between 0 and 360 (if
\code{degrees=TRUE}) or between 0 and \eqn{2\pi} (if
\code{degrees=FALSE}).}

\item{plg}{plunge angle, in degrees, between 0 and 90 (if
\code{degrees=TRUE}) or between 0 and \eqn{2\pi} (if
\code{degrees=FALSE}).}

\item{coneAngle}{if \code{option=4}, controls the radius of a small
circle around the pole with azimuth \code{trd} and dip
\code{plg}.}

\item{option}{scalar. If \code{option=1} or \code{option=4}, then
\code{trd} is the azimuth and \code{plg} is the dip; if
\code{option=2}, then \code{trd} is the strike and \code{plg}
is the dip; if \code{option=3}, then \code{trd} is the
longitude and \code{plg} is the latitude.}

\item{wulff}{logical. If \code{FALSE}, produces a Schmidt net.}

\item{add}{logical. If \code{TRUE}, adds to an existing stereonet.}

\item{degrees}{logical. If \code{FALSE}, assumes that
\code{azimuth} and \code{dip} are in radians.}

\item{show.grid}{logical. If \code{TRUE}, decorates the plot with a
grid of great and small circles.}

\item{grid.col}{colour of the grid.}

\item{tl}{tick length for the N, E, S, W markers (value between 0
and 1).  Set to 0 to omit the markers.}

\item{type}{if \code{option=1} or \code{3}, coordinates can be
visualsed as points (\code{type='p'}), lines (\code{type='l'})
or decorated with text labels (\code{type='t'}).}

\item{labels}{if \code{option=1} or \code{3} and \code{type='t'},
specifies the text labels to be used to mark the measurements
on the stereonet.}

\item{...}{optional arguments to be passed on to the generic
\code{points} function}
}
\description{
Plots directional data on a Wulff or Schmidt
    stereonet. The Wulff equal angle polar Lambert projection
    preserves the shape of objects and is often used to visualise
    structural data.  The Schmidt equal area polar Lambert
    projection preserves the size of objects and is more popular in
    mineralogy.
}
\examples{
stereonet(trd=c(120,80),plg=c(10,30),degrees=TRUE,pch=16)
stereonet(trd=c(120,80),plg=c(10,30),degrees=TRUE,
          option=4,coneAngle=c(5,10),add=TRUE)
}
\references{
Allmendinger, R.W., Cardozo, N., and Fisher,
    D.M. ``Structural geology algorithms: Vectors and
    tensors''. Cambridge University Press, 2011.
}
\author{
based on a MATLAB script written by Nestor Cardozo.
}
