% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar.color.R
\name{color.bar}
\alias{color.bar}
\title{Graphic Representation of a Color bar, function written by John Colby}
\usage{
color.bar(lut, min, max = -min, nticks = 11, ticks = seq(min, max, len =
  nticks), title = "", width = 1.75, height = 5, ncolmax = 100,
  digits = 4, pdf = NULL)
}
\arguments{
\item{lut}{see reference \url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}}

\item{min}{see reference \url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}}

\item{max}{see reference \url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}}

\item{nticks}{see reference \url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}}

\item{ticks}{see reference \url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}}

\item{title}{see reference \url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}}

\item{width, height}{width and height of the device}

\item{ncolmax}{maximum number of colors. Default is 100.}

\item{digits}{specified number of significant digits}

\item{pdf}{character value for pdf output file.  Default is \code{NULL} and no pdf file is created.}
}
\description{
Graphic Representation of a Color bar, function written by John Colby
}
\note{
This function is taken from \url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}. Plese visit the URL for major details and give your feedback if possible.
}
\examples{
color.bar(colorRampPalette(c("light green", "yellow", "orange", "red"))(100), -1)



}
\author{
John Colby \url{http://stackoverflow.com/users/412342/john-colby}
}
\references{
\url{http://stackoverflow.com/questions/9314658/colorbar-from-custom-colorramppalette}
}

