% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getvalues.brick.at.depth.R
\name{getvalues.brick.at.depth}
\alias{getvalues.brick.at.depth}
\title{Interpolates the values of a 'brick' at a certain depth  and returns the map of brick values at the "depth" level}
\usage{
getvalues.brick.at.depth(x, depth, layers, i0 = NULL, verify = FALSE,
  ...)
}
\arguments{
\item{x}{a 'RasterBrick' or a three-dimensional array}

\item{depth}{depth map, generally a 'RasterLayer' object}

\item{layers}{vector of layer thickness}

\item{i0}{a 'Raster' containing the number of soil laver just over the bedrock. Default is \code{NULL} and is then calculated.}

\item{verify}{logical. Default is \code{FALSE}. If it is \code{TRUE}, it verifies that function is working correctly.}

\item{...}{further argument}
}
\value{
a list of 'Raster' maps: 

\code{i0}   a 'Raster' containing the number of soil laver just over the bedrock

\code{val_z0}   a 'Raster' containing the values of \code{x} at the \code{i0}-th layer

\code{val_z1}   a 'Raster' containing the values of \code{x} at the (\code{i0}+1)-th layer 

\code{z0}       a 'Raster' containing the depth of the center  of  the \code{i0}-th layer

\code{z1}       a 'Raster' containing the depth of the center  of  the (\code{i0}+1)-th layer
}
\description{
Interpolates the values of a 'brick' at a certain depth  and returns the map of brick values at the "depth" level
}
\note{
\code{x} and \code{depth} or \code{i0} must cover the same spatial region.
}
\examples{

library(geotopbricks)
# The examples is the following R script conteined in a 'inst' directory of the package source
f <- system.file("doc/examples/example.getvalues.brick.at.depth.R",package="geotopbricks")
#  source(f) # Uncomment this line to run the example. 
# You can copy the example file using file.copy(from=f,to=....,...) See file.copy documentation
}
\seealso{
code{\link{vertical.aggregate.brick.within.depth}}
}
