% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeanGermTime.R
\name{MeanGermTime}
\alias{MeanGermTime}
\alias{VarGermTime}
\alias{SEGermTime}
\alias{CVSEGermTime}
\title{Germination Time}
\usage{
MeanGermTime(germ.counts, intervals, partial = TRUE)

VarGermTime(germ.counts, intervals, partial = TRUE)

SEGermTime(germ.counts, intervals, partial = TRUE)

CVSEGermTime(germ.counts, intervals, partial = TRUE)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial or
cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
For \code{MeanGermTime}, the mean germination time value in the same
 unit of time as specified in the argument \code{intervals}.

 For \code{VarGermTime}, the variance of germination time value as
 \ifelse{html}{\out{time<sup>2</sup>}}{\eqn{\mathrm{time^{2}}}}.

 For \code{SEGermTime}, the standard error of germination time in the same
 unit of time specified in the argument \code{intervals}.

 For \code{CVSEGermTime}, the value of coefficient of variation of the
 germination time.
}
\description{
Compute the following metrics:\describe{ \item{\code{MeanGermTime}}{Mean
germination time (\ifelse{html}{\out{<em><span
style="text-decoration:overline">T</span></em>}}{\eqn{\overline{T}}}) or Mean
length of incubation time.} \item{\code{VarGermTime}}{Variance of germination
time (\ifelse{html}{\out{<em>s<sup>2</sup><sub style="line-height: 1.8;
margin-left: -1ex;">T</sub></em>}}{\eqn{s_{T}^{2}}}).}
\item{\code{SEGermTime}}{Standard error of germination time
(\ifelse{html}{\out{<em>s<sub><span
style="text-decoration:overline">T</span></sub></em>}}{\eqn{s_{\overline{T}}}}).}
\item{\code{CVSEGermTime}}{ Coefficient of variation of the germination time
(\ifelse{html}{\out{<i>CV<sub>T</sub></i>}}{\eqn{CV_{T}}}).} }
}
\details{
\code{MeanGermTime} computes the mean germination time according to the
following formula (Edmond and Drapala, 1958; Czabator, 1962; Ellis and
Roberts, 1980; Labouriau, 1983; Ranal and de Santana, 2006).

\ifelse{html}{\out{<p style="text-align: center;"><em><span
style="text-decoration: overline;">T</span> = <sup>&sum;<sup>k</sup><sub
style="line-height: 1.8; margin-left: -1ex;">i=1</sub>
N<sub>i</sub>T<sub>i</sub></sup> &frasl; <sub>&sum;<sup>k</sup><sub
style="line-height: 1.8; margin-left: -1ex;">i=1</sub>
N<sub>i</sub></sub></em></p>}}{\deqn{\overline{T} =
\frac{\sum_{i=1}^{k}N_{i}T_{i}}{\sum_{i=1}^{k}N_{i}}}}

Where, \ifelse{html}{\out{<i>T<sub>i</sub></i>}}{\eqn{T_{i}}} is the time from
the start of the experiment to the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation,
\ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number of seeds
germinated in the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (not the accumulated number, but the number
correspondent to the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation) and \ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last time of
germination.

It is the inverse of mean germination rate (\ifelse{html}{\out{<em><span
style="text-decoration:overline">V</span></em>}}{\eqn{\overline{V}}}).

\ifelse{html}{\out{<p style="text-align: center;"><em><span
style="text-decoration: overline;">T</span> = <sup>1</sup> &frasl; <sub><span
style="text-decoration:
overline;">V</span></sub></em></p>}}{\deqn{\overline{T} =
\frac{1}{\overline{V}}}}

It indicates the average length of time required for maximum germination of a
seed lot. Lower the \ifelse{html}{\out{<em><span
style="text-decoration:overline">T</span></em>}}{\eqn{\overline{T}}}, faster
the sample has germinated and reflects seed vigor.

\code{VarGermTime} computes the variance of germination time according to the
following formula.

\ifelse{html}{\out{<p style="text-align: center;"><em>s<sup>2</sup><sub
style="line-height: 1.8; margin-left: -1ex;">T</sub> =
<sup>&sum;<sup>k</sup><sub style="line-height: 1.8; margin-left:
-1ex;">i=1</sub> N<sub>i</sub>(T<sub>i</sub> &minus; <span
style="text-decoration: overline;">T</span>)<sup>2</sup></sup> &frasl; <sub>
&sum;<sup>k</sup><sub style="line-height: 1.8; margin-left: -1ex;">i=1</sub>
N<sub>i</sub> &minus; 1</sub></em></p>}}{\deqn{s_{T}^{2} =
\frac{\sum_{i=1}^{k}N_{i}(T_{i}-\overline{T})^{2}}{\sum_{i=1}^{k}N_{i}-1}}}

Where, \ifelse{html}{\out{<i>T<sub>i</sub></i>}}{\eqn{T_{i}}} is the time from
the start of the experiment to the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation,
\ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number of seeds
germinated in the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (not the accumulated number, but the number
correspondent to the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation) and \ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last time of
germination.

\code{SEGermTime} computes the standard error of germination time
(\ifelse{html}{\out{<em>s<sub><span
style="text-decoration:overline">T</span></sub></em>}}{\eqn{s_{\overline{T}}}})
according to the following formula.

\ifelse{html}{\out{<p style="text-align: center;"><em>s<sub><span
style="text-decoration: overline;">T</span></sub> = &radic;[
<sup>s<sup>2</sup><sub style="line-height: 1.8; margin-left:
-1ex;">T</sub></sup> &frasl; <sub>&sum;<sup>k</sup><sub style="line-height:
1.8; margin-left: -1ex;">i=1</sub> N<sub>i</sub></sub>
]</em></p>}}{\deqn{s_{\overline{T}} =
\sqrt{\frac{s_{T}^{2}}{\sum_{i=1}^{k}N_{i}}}}}

Where, \ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number of
seeds germinated in the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (not the accumulated number, but the
number correspondent to the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation) and \ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last
time of germination.

It signifies the accuracy of the calculation of the mean germination time.

\code{CVGermTime} computes the coefficient of variation of germination time
(\ifelse{html}{\out{<i>CV<sub>T</sub></i>}}{\eqn{CV_{T}}}) according to the
following formula (Ranal and de Santana, 2006).

\ifelse{html}{\out{<p style="text-align: center;"><em>CV<sub>T</sub> =
&radic;[ <sup>s<sup>2</sup><sub style="line-height: 1.8; margin-left:
-1ex;">T</sub></sup> &frasl; <sub><span style="text-decoration:
overline;">T</span></sub> ]</em></p>}}{\deqn{CV_{T} =
\sqrt{\frac{s_{T}^{2}}{\overline{T}}}}}

This indicates the uniformity of germination and permits comparisons
irrespective of the magnitude of mean germination time
(\ifelse{html}{\out{<em><span
style="text-decoration:overline">T</span></em>}}{\eqn{\overline{T}}}).
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
MeanGermTime(germ.counts = x, intervals = int)
VarGermTime(germ.counts = x, intervals = int)
SEGermTime(germ.counts = x, intervals = int)
CVSEGermTime(germ.counts = x, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
MeanGermTime(germ.counts = y, intervals = int, partial = FALSE)
VarGermTime(germ.counts = y, intervals = int, partial = FALSE)
SEGermTime(germ.counts = y, intervals = int, partial = FALSE)
CVSEGermTime(germ.counts = y, intervals = int, partial = FALSE)

}
\references{
\insertRef{edmond_effects_1958}{germinationmetrics}

\insertRef{czabator_germination_1962}{germinationmetrics}

\insertRef{ellis_improved_1980}{germinationmetrics}

\insertRef{labouriau_germinacao_1983}{germinationmetrics}

\insertRef{ranal_how_2006}{germinationmetrics}
}
\seealso{
\code{\link[germinationmetrics]{MeanGermRate}}
}
