% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_functions.R
\name{frontierpower}
\alias{frontierpower}
\title{Calculate Frontier power from number of events}
\usage{
frontierpower(
  events,
  HR,
  Eratio,
  Rratio = 1,
  startpower = 0.5,
  alpha1 = 0.025,
  iter = 10
)
}
\arguments{
\item{events}{Number of events.}

\item{HR}{Hazard Ratio. Values below 1 indicate a benefit to the active arm vs control.}

\item{Eratio}{Event ratio.}

\item{Rratio}{Randomisation ratio. Default=1.}

\item{startpower}{Initial estimate of power. Default=0.5.}

\item{alpha1}{1-sided alpha. Default=0.025.}

\item{iter}{Number of iterations to perform. Default=10.}
}
\value{
Power as a decimal
}
\description{
Calculate Frontier power from number of events
}
\examples{
frontierpower(events=300,HR=0.7,Eratio=1.2,Rratio=1.5,alpha1=0.025)
}
\references{
Bell J, Power Calculations for Time-to-Event Trials Using Predicted Event Proportions, 2019, paper under review.
}
\author{
James Bell
}
