% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_architecture.R
\name{plotRecruitment,RCurve-method}
\alias{plotRecruitment,RCurve-method}
\title{Method for plotting the Recruitment Function of a RCurve object}
\usage{
\S4method{plotRecruitment}{RCurve}(
  theObject,
  overlay = FALSE,
  maxT = 100,
  increment = 0.1,
  xlab = "Time",
  ylab = "Patients",
  main = "Recruitment plot",
  type = "l",
  ...
)
}
\arguments{
\item{theObject}{The name of the RCurve Object}

\item{overlay}{Boolean whether to overlay on existing one (vs start a new one). Default=FALSE}

\item{maxT}{Maximum time to plot up to. Default=100}

\item{increment}{Plotting time increment. Default=0.1}

\item{xlab}{X-axis label. Default="Time"}

\item{ylab}{Y-axis label. Default="Patients"}

\item{main}{title of plot. Default="Recruitment plot"}

\item{type}{type of plot (see standard graphical parameters). Default="l" (lines).}

\item{...}{Standard graphical parameter arguments to be passed on to 'plot'/'lines', e.g. to change appearance of plot.}
}
\description{
This plots an RCurve Recruitment Function
}
\examples{
plotRecruitment(LinearR(12,100,100))
plotRecruitment(LinearR(12,100,100),xlab="Test x label",maxT=60)
plotRecruitment(LinearR(20,90,90),overlay=TRUE,col=2,lty=2)
}
