% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{set_event_number}
\alias{set_event_number}
\title{Adjusts simulations so that administrative censoring occurs at a fixed event number, rather than a fixed time}
\usage{
set_event_number(
  data,
  events,
  output_type = c("input", "matrix", "list"),
  detailed_output = TRUE
)
}
\arguments{
\item{data}{Output file from simulate_trials() or simulate_trials_strata() in either "list" or "matrix" format. Only these formats are supported.}

\item{events}{Positive integer specifying the required number of events.}

\item{output_type}{Choice of "input" (output in same format as input),"matrix" (matrix format output) or "list" (list format output). Default="input".}

\item{detailed_output}{Boolean to require full details of timings of competing processes. If FALSE, the simplified data only includes the *'ed output columns - this approximately halves RAM requirements. Default=TRUE (detailed).}
}
\value{
Returns the input simulated trial, in either matrix or list format, with modified assessment times. All columns dependent on this are also updated.
}
\description{
Function for converting trials simulated by simulate_trials() or simulate_trials_strata() from a fixed censoring time to a fixed number of total events.\cr
It is set up to automatically read in either matrix or list formats from simulate_trials() or simulate_trials_strata(), and only these inputs are supported.\cr
Note that if recruitment had not finished in the input then any increases in assessment time cannot account for the missing patients.
It is therefore strongly recommended to initially simulate for at least the duration of the recruitment before fixing the event number.\cr
This function can also be used to change format and/or slim down data for event-driven simulations.\cr
}
\examples{
example_sim <- simulate_trials(active_ecurve=Weibull(250,0.8),control_ecurve=Weibull(100,1),
rcurve=LinearR(12,100,100), assess=20,iterations=5,seed=12345,detailed_output=TRUE)

adjusted_examples <- set_event_number(data=example_sim,events=50)
}
\author{
James Bell
}
