% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shh.R
\name{shh_post}
\alias{shh_post}
\title{New whisper message.}
\usage{
shh_post(symKeyID = NULL, pubKey = NULL, sig = NULL, ttl,
  topic = NULL, payload, padding = NULL, powTime, powTarget,
  targetPeer = NULL)
}
\arguments{
\item{symKeyID}{String - ID of the symmetric key for message encryption.}

\item{pubKey}{String - Public key for message encryption.}

\item{sig}{String - ID of the signing key.}

\item{ttl}{Integer - Time-to-live in seconds.}

\item{topic}{String - Message topic (mandatory when key is symmetric).}

\item{payload}{String - Payload to be encrypted.}

\item{padding}{String - Optional padding (byte array of arbitrary length).}

\item{powTime}{Integer - Maximal time in seconds to be spent on proof of
work.}

\item{powTarget}{Integer - Minimal PoW target required for this message.}

\item{targetPeer}{String - Optional peer ID (for peer-to-peer message only).}
}
\value{
Boolean - \code{true} if the message was send, otherwise
  \code{false}.
}
\description{
\code{shh_post} creates a whisper message and injects it into the network for
distribution.
}
\examples{
\donttest{
shh_post(symKeyID = '7bc23b46b61e8223ef49241bd23b94921fb1e2dd8fd7bcb58df41
59e1f4d3759', ttl = 7, topic = '0x07678231', payload = '0x68656c6c6f',
powTime = 2, powTarget = 3)
shh_post(pubKey = '0x0425670405b102c0ce487cefae7aa2bfd7b474b76bc8433499bec
777bb15d6d8a6b95e3001d16de259bf3170ec4cff38f00321eedc8a808a2f2e67bec6b254a
1b1', ttl = 7, payload = '0x68656c6c6f', powTime = 2, powTarget = 3)
}

}
\seealso{
Other shh functions: \code{\link{gethr}},
  \code{\link{shh_addPrivatekey}},
  \code{\link{shh_addSymKey}},
  \code{\link{shh_deleteKeyPair}},
  \code{\link{shh_deleteSymKey}},
  \code{\link{shh_generateSymKeyFromPassword}},
  \code{\link{shh_getPrivateKey}},
  \code{\link{shh_getPublicKey}},
  \code{\link{shh_getSymKey}},
  \code{\link{shh_hasKeyPair}},
  \code{\link{shh_hasSymKey}}, \code{\link{shh_info}},
  \code{\link{shh_markTrustedPeer}},
  \code{\link{shh_newKeyPair}},
  \code{\link{shh_newMessageFilter}},
  \code{\link{shh_newSymKey}},
  \code{\link{shh_setMaxMessageSize}},
  \code{\link{shh_setMinPoW}}, \code{\link{shh_version}}
}
\concept{shh functions}
