% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gen_grid}
\alias{gen_grid}
\title{Generate a spatial grid}
\usage{
gen_grid(origin_x, dx, max_x, origin_y, dy, max_y, grid_proj4string = NULL)
}
\arguments{
\item{origin_x}{x coordinate of the origin}

\item{dx}{cell size in the x direction}

\item{max_x}{maximum value in x direction}

\item{origin_y}{y coordinate of the origin}

\item{dy}{cell size in the y direction}

\item{max_y}{maximum value in y direction}

\item{grid_proj4string}{coordinate system as a crs object (defaults to
WGS-84)}
}
\description{
Produces an arbitrary grid in any user-defined coordinate system. Used by
\code{gfcanalysis} for producing the 10x10 degree WGS84 grid that the GFC
product is tiled on, so that an AOI polygon can be intersected with the grid
to calculate the appropriate tiles to download.
}
\examples{
gfc_tiles <- gen_grid(-180, 10, 180, -60, 10, 80)
}
\seealso{
\code{\link{download_tiles}}
}

