% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_2DhistMatrix.r
\name{ggInterval_2DhistMatrix}
\alias{ggInterval_2DhistMatrix}
\title{2-Dimension histogram matrix}
\usage{
ggInterval_2DhistMatrix(data = NULL,mapping = aes(NULL)
,xBins = 8,yBins=8,removeZero = FALSE,
addFreq = TRUE)
}
\arguments{
\item{data}{A ggESDA object. It can also be either RSDA object or
classical data frame, which will be automatically convert to ggESDA
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.
It is the same as the mapping of ggplot2.}

\item{xBins}{x axis bins,which mean how many bins
x variable will be separate into}

\item{yBins}{y axis bins. It is the same as xBins}

\item{removeZero}{whether remove data whose frequency is equal to zero}

\item{addFreq}{where add frequency text in each cells.}
}
\value{
Return a plot with ggplot2 object
}
\description{
Visualize the all continuous variable distribution
by dividing both the x axis and y axis into bins,and calculating
the frequency of observation interval in each bin.Eventually
show it by a matrix plot. Note: this function will automatically
filter out the discrete variables,and plot all continuous in
input data, so it can not be necessary that give the particularly
variables in aes such like (aes(x = x, y = y)). It isn't also
recommended to deal with too many variables because the
big O in calculating full matrix will be too large.
}
\examples{
ggInterval_2DhistMatrix(oils, xBins = 5, yBins = 5)

}
