% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_growth.R
\name{plot_growth}
\alias{plot_growth}
\title{Plot age-length relationships and growth curves}
\usage{
plot_growth(
  dt,
  length = "length",
  age = "age",
  sex = "sex",
  female.sex = "F",
  male.sex = "M",
  length.unit = "cm",
  split.by.sex = FALSE,
  growth.model = 1,
  force.zero.group.length = NA,
  force.zero.group.strength = 10,
  force.zero.group.cv = 0,
  show.Linf = TRUE,
  boxplot = TRUE,
  base_size = 8,
  legend.position = "bottom"
)
}
\arguments{
\item{dt}{A data.frame, tibble or data.table}

\item{length}{Character argument giving the name of the length column in \code{dt}}

\item{age}{Character argument giving the name of the age column in \code{dt}}

\item{sex}{Character argument giving the name of the sex column in \code{dt}. Ignored if \code{split.by.sex == FALSE}.}

\item{female.sex, male.sex}{A character or integer denoting female and male sex in the \code{sex} column of \code{dt}, respectively.}

\item{length.unit}{A character argument giving the unit of \code{length}. Will be used in the labels of the figure.}

\item{split.by.sex}{Logical indicating whether the result should be split by sex.}

\item{growth.model}{Integer defining the growth model. 1 = von Bertalanffy, 2 = Gompertz, 3 = Logistic.}

\item{force.zero.group.length}{Numeric indicating the length to which 0-group should be forced. Use \code{NA} ignore the forcing.}

\item{force.zero.group.strength}{Numeric indicating how many percent of total fish should be added to the specified \code{force.zero.group.length}.}

\item{force.zero.group.cv}{Numeric indicating the coefficient of variation for the forced 0-group length. Resulting lengths will be randomly generated from a normal distribution.}

\item{show.Linf}{Logical indicating whether Linf values should be shown as dashed vertical lines.}

\item{boxplot}{Logical indicating whether boxplots (\code{TRUE}) should be used to show data over points (\code{FALSE})}

\item{base_size}{Base size parameter for ggplot. See \link[ggplot2]{ggtheme}.}

\item{legend.position}{Position of the ggplot legend as a character. See \link[ggplot2]{ggtheme}.}
}
\value{
A list containing the \code{plot}, \code{text} for Rmarkdown and Shiny applications, and estimated parameters (\code{params}).
}
\description{
Plot age-length relationships and growth curves
}
\details{
Uses the \code{fishmethods::growth} function to calculate the growth curves. Zero group length can be forced to the growth functions using the \code{force.zero.group.*} parameters.
}
\examples{
# Simple plot. Note that a list is returned.
data(survey_ghl)
plot_growth(survey_ghl, length = "length", age = "age")
\donttest{
# Split by sex
plot_growth(survey_ghl, split.by.sex = TRUE)$plot
# Data as points. Forcing zero group to 10 cm
plot_growth(survey_ghl, force.zero.group.length = 10, boxplot = FALSE)$plot
}
}
\author{
Mikko Vihtakari // Institute of Marine Research.
}
