% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx_read_nm_model.R
\name{pmx_read_nm_model}
\alias{pmx_read_nm_model}
\title{NONMEM model file parser}
\usage{
pmx_read_nm_model(
  runno = NULL,
  prefix = "run",
  ext = ".lst",
  file = NULL,
  dir = NULL
)
}
\arguments{
\item{runno}{run number which is used for generating the model file name}

\item{prefix}{Prefix to be used to generate model file name. Used in combination with \code{runno} and \code{ext}.}

\item{ext}{Extension to be used to generate model file name. Should be one of'.lst' (default), '.out', '.res', '.mod' or '.ctl' for NONMEM.}

\item{file}{A character vector of path to the files or a \code{nm_table_list} object created with \code{list_nm_tables}.}

\item{dir}{directory of the model files.}
}
\value{
A \code{\link[dplyr]{tibble}} of class \code{model} containing the following columns: 
\itemize{
 \item{\strong{problem}}{: a numeric identifier for the $PROBLEM associated with the code.}
 \item{\strong{level}}{: a unique numeric identifier to each subroutine block associated with the code.}
 \item{\strong{subroutine}}{: a character identifier named after the 3 first letters of the subroutine name e.g. '$THETA' and 
 '$TABLE' will become 'the' and 'tab' respectively. In addition all output from the .lst is labeled 'lst', the general nonmem 
 output e.g. NM-TRAN messages are labelled 'oth'. With priors thp, tpv, omp, opd, sip, spd abbreviations are given to the THETAP, 
 THETAPV, OMEGAP, etc.}
 \item{\strong{code}}{: the code without comments or subroutine names e.g. '$THETA 0.5 ; TVCL' will return '0.5'.}
 \item{\strong{comment}}{: the last comment of a record e.g. '0.5 ; Clearance (L/h) ; TVCL' will return 'TVCL'.}
}
}
\description{
Parse NONMEM model files in R format
}
\examples{
\dontrun{
# Using the `file` argument to import a model file:
nm_model <- pmx_read_nm_model(file = 'run001.lst', dir = 'models')

# Using the `runno` argument to import a model file:
nm_model <- pmx_read_nm_model(runno = '001', ext = '.lst', dir = 'models')
}

}
\seealso{
\code{\link{pmx_read_nm_tables}}
}
