% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxClass.R
\name{pmx_settings}
\alias{pmx_settings}
\title{Create controller global settings}
\usage{
pmx_settings(
  is.draft = TRUE,
  use.abbrev = TRUE,
  color.scales = NULL,
  cats.labels = NULL,
  use.labels = FALSE,
  use.titles = TRUE,
  effects = NULL,
  ...
)
}
\arguments{
\item{is.draft}{\code{logical} if FALSE any plot is without draft annotation}

\item{use.abbrev}{\code{logical} if FALSE use full description from abbreviation mapping for axis names}

\item{color.scales}{\code{list} list containing elements of scale_color_manual}

\item{cats.labels}{\code{list} list of named vectors for each factor}

\item{use.labels}{\code{logical} if TRUE replace factor named by cats.labels}

\item{use.titles}{\code{logical} FALSE to generate plots without titles}

\item{effects}{\code{list} list of effects levels and labels}

\item{...}{extra parameter not used yet}
}
\value{
pmxSettingsClass object
}
\description{
Create controller global settings
}
\examples{
\donttest{

library(ggPMX)
library(ggplot2)
ctr <- theophylline(
  settings=
    pmx_settings(
      color.scales=list(
        "Study",
        labels=c("Study 1","Study 2"),
        values=c("1"="lightyellow","2"="lightblue")),
      cats.labels=list(
        SEX=c("0"="M","1"="F"),
        STUD=c("1"="Study 1","2"="Study 2")
      ),
      use.abbrev=TRUE,
      is.draft=TRUE,
      use.labels=TRUE
    )
)



ctr \%>\% 
  pmx_plot_npde_time(strat.color="STUD",strat.facet=~SEX)
# 
# 
ctr  \%>\%
  pmx_plot_eta_box(strat.color="STUD", strat.facet =~SEX)

ctr  \%>\%  pmx_plot_eta_hist
}
}
