% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_roc.R
\name{calc_auc}
\alias{calc_auc}
\alias{calc_auc.gg_roc}
\title{Area Under the ROC Curve calculator}
\usage{
calc_auc(x)
}
\arguments{
\item{x}{\code{\link{gg_roc}} object}
}
\value{
AUC. 50\% is random guessing, higher is better.
}
\description{
Area Under the ROC Curve calculator
}
\details{
calc_auc uses the trapezoidal rule to calculate the area under
the ROC curve.

 This is a helper function for the \code{\link{gg_roc}} functions.
}
\examples{
##
## Taken from the gg_roc example
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
data(rfsrc_iris)

\dontrun{
gg_dta <- gg_roc(rfsrc_iris, which.outcome=1)

calc_auc(gg_dta)
}

gg_dta <- gg_roc(rfsrc_iris, which.outcome=2)

calc_auc(gg_dta)

}
\seealso{
\code{\link{calc_roc}} \code{\link{gg_roc}} \code{\link{plot.gg_roc}}
}

