% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_occurrence.R
\name{stat_occurrence}
\alias{stat_occurrence}
\title{Plots a time series as a dot plot}
\usage{
stat_occurrence(mapping = NULL, data = NULL, show.legend = NA,
  inherit.aes = TRUE, na.rm = T, bandwidth = NULL, ...)
}
\arguments{
\item{mapping}{mapping}

\item{data}{df}

\item{show.legend}{logical}

\item{inherit.aes}{logical}

\item{na.rm}{logical}

\item{bandwidth}{bandwidth}

\item{...}{more functions

For rare events, it's convenient to have the count of events encoded in
the chart itself. A bar chart requires the user to perceive the y axis which
this does not.}
}
\description{
Plots a time series as a dot plot
}
\section{Aesthetics}{
 x, y
}

\section{Cosmetic Tips}{
 The minimalist look can be achieved by appending the
following chunk of code to the output object:
\code{  +
   xlab(NULL) +
   ylab(NULL) +
   scale_fill_continuous(low = 'green', high = 'red') +
   theme(
      axis.text.y = element_blank(),
      axis.ticks.y = element_blank(),
      legend.position = 'none',
      strip.background = element_blank(),
      panel.background = element_blank(),
      panel.border = element_blank(),
      panel.grid = element_blank(),
      panel.border = element_blank()
   ) +
   coord_fixed(ylim = c(0,1 + max(dfData$y)))
}
 \link[ggplot2]{coord_fixed}  can provide a balance to the aspect ratio of the chart.
}

\examples{
{
library(data.table)
library(ggplot2)
set.seed(1)
dfData = data.table(x = 1:100, y = floor(4 * abs(rnorm(100, 0 , 0.4))))
ggplot(dfData, aes(x =x, y = y) )+
   stat_occurrence()+
   coord_fixed()}
}
