## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.asp = 0.618,
  fig.align = "center"
)

## -----------------------------------------------------------------------------
genes <- paste0("gene",1:1000)
set.seed(20210302)
gene_list <- list(A = sample(genes,100),
                  B = sample(genes,200),
                  C = sample(genes,300),
                  D = sample(genes,200))

library(ggVennDiagram)
library(ggplot2)

## -----------------------------------------------------------------------------
p1 <- ggVennDiagram(gene_list, 
                    category.names = c("a very long name","short name","name","another name"))
p1

# expand axis to show long set labels
p1 + scale_x_continuous(expand = expansion(mult = .2))

## -----------------------------------------------------------------------------
set.seed(0)
small_list <- lapply(sample(6:10, size = 4), function(x){
  sample(letters,x)
})

ggVennDiagram(small_list, 
                    category.names = LETTERS[1:4], 
                    show_intersect = TRUE)

## -----------------------------------------------------------------------------
ggVennDiagram(gene_list, set_color = c("blue","black","red","yellow"))

## -----------------------------------------------------------------------------
ggVennDiagram(gene_list, set_size = 8)

## ----eval=FALSE---------------------------------------------------------------
#  ggVennDiagram(gene_list, label = "count")
#  ggVennDiagram(gene_list, label = "percent")
#  ggVennDiagram(gene_list, label = "both")
#  ggVennDiagram(gene_list, label = "none")

## ----fig.width=12, echo=FALSE-------------------------------------------------
plots = lapply(c("none","count","percent","both"), function(x){
  ggVennDiagram(gene_list,label = x) + 
    labs(title = paste0('label = "', x, '"')) +
    theme(legend.position = "none")
})
aplot::plot_list(gglist = plots, ncol = 2, labels = LETTERS[1:4])

## -----------------------------------------------------------------------------
ggVennDiagram(gene_list, label_percent_digit = 1, label = "percent")

## -----------------------------------------------------------------------------
ggVennDiagram(gene_list, label_alpha = 0)

## -----------------------------------------------------------------------------
ggVennDiagram(gene_list, label_geom = "text")

## -----------------------------------------------------------------------------
ggVennDiagram(gene_list, label_color = "firebrick", label_size = 4)

## -----------------------------------------------------------------------------
ggVennDiagram(gene_list, edge_lty = "dashed", edge_size = 1)

## -----------------------------------------------------------------------------
library(ggplot2)
p <- ggVennDiagram(gene_list)

# Red Blue
p + scale_fill_distiller(palette = "RdBu")

# Reds
p + scale_fill_distiller(palette = "Reds", direction = 1)

## ----fig.asp=2, fig.width=4---------------------------------------------------
RColorBrewer::display.brewer.all()

## -----------------------------------------------------------------------------
p + labs(title = "Fancy Venn Diagram of four sets",
         subtitle = "Generated by `ggVennDiagram`",
         caption = Sys.Date())

