% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheme-data.R
\name{scheme_data}
\alias{scheme_data}
\title{Plot data Specifications}
\usage{
scheme_data(data, inherit = FALSE)
}
\arguments{
\item{data}{A function to transform the plot data before rendering.
Acceptable values include:
\itemize{
\item \code{NULL}: No action taken.
\item \code{\link[ggplot2:waiver]{waiver()}}: Inherits from the parent layout.
\item A \code{function} or purrr-style \code{formula}: Used to transform the plot data,
which should accept a data frame and return a data frame. You can apply
this after the parent layout \code{scheme_data} function, using the \code{inherit}
argument.
}

Use this hook to modify the data for all \code{geoms} after the layout is created
(for matrix data, it has been melted to a long format data frame) but before
rendering by \code{ggplot2}. The returned data must be a data frame for ggplot.}

\item{inherit}{A single boolean value indicates whether to apply the parent
\code{scheme_data} first and then apply the specified \code{scheme_data} for the plot.
Defaults to \code{FALSE}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Transforms the plot data. Many functions in this package require a specific
data format to align observations, \code{scheme_data()} helps reformat data frames
as needed.
}
\details{
Defaults will attempt to inherit from the parent layout if the actual data is
inherited from the parent layout, with one exception: \code{align_dendro()}, which
will not inherit the \code{scheme_data} by default.
}
