% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lode-guidance-functions.r
\name{lode-guidance-functions}
\alias{lode-guidance-functions}
\alias{lode_zigzag}
\alias{lode_forward}
\alias{lode_rightward}
\alias{lode_backward}
\alias{lode_leftward}
\alias{lode_frontback}
\alias{lode_rightleft}
\alias{lode_backfront}
\alias{lode_leftright}
\title{Lode guidance functions}
\usage{
lode_zigzag(n, i)

lode_forward(n, i)

lode_rightward(n, i)

lode_backward(n, i)

lode_leftward(n, i)

lode_frontback(n, i)

lode_rightleft(n, i)

lode_backfront(n, i)

lode_leftright(n, i)
}
\arguments{
\item{n}{Numeric, a positive integer}

\item{i}{Numeric, a positive integer at most \code{n}}
}
\description{
These functions control the order of lodes within strata in an alluvial
diagram. They are invoked by \code{\link[=stat_alluvium]{stat_alluvium()}} and can be passed to
the \code{lode.guidance} parameter.
}
\details{
Each function orders the numbers 1 through \code{n}, starting at index
\code{i}. The choice of function made in \code{\link[=stat_alluvium]{stat_alluvium()}}
determines the order in which the other axes contribute to the sorting of
lodes within each index axis. After starting at \code{i}, the functions order
the remaining axes as follows:
\itemize{
\item \code{zigzag}: Zigzag outward from \code{i}
\item \code{forward}: Increasing order (alias \code{rightward})
\item \code{backward}: Decreasing order (alias \code{leftward})
\item \code{frontback}: Proceed forward from \code{i} to \code{n}, then backward to 1
(alias \code{rightleft})
\item \code{backfront}: Proceed backward from \code{i} to 1, then forward to \code{n}
(alias \code{leftright})
}
}
