% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmute-.R, R/transmute-enter.R,
%   R/transmute-exit.R
\name{enter_exit}
\alias{enter_exit}
\alias{enter}
\alias{exit}
\alias{enter_manual}
\alias{enter_appear}
\alias{enter_fade}
\alias{enter_grow}
\alias{enter_recolour}
\alias{enter_recolor}
\alias{enter_fly}
\alias{enter_drift}
\alias{enter_reset}
\alias{exit_manual}
\alias{exit_disappear}
\alias{exit_fade}
\alias{exit_shrink}
\alias{exit_recolour}
\alias{exit_recolor}
\alias{exit_fly}
\alias{exit_drift}
\alias{exit_reset}
\title{Define how entering and exiting data behaves}
\usage{
enter_manual(default = NULL, ..., name = "manual")

enter_appear(early = FALSE, ...)

enter_fade(..., alpha = 0)

enter_grow(..., size = 0)

enter_recolour(..., colour = "white", fill = colour)

enter_recolor(..., color = "white", fill = color)

enter_fly(..., x_loc = NA, y_loc = NA)

enter_drift(..., x_mod = 0, y_mod = 0)

enter_reset()

exit_manual(default = NULL, ..., name = "manual")

exit_disappear(early = FALSE, ...)

exit_fade(..., alpha = 0)

exit_shrink(..., size = 0)

exit_recolour(..., colour = "white", fill = colour)

exit_recolor(..., color = "white", fill = color)

exit_fly(..., x_loc = NA, y_loc = NA)

exit_drift(..., x_mod = 0, y_mod = 0)

exit_reset()
}
\arguments{
\item{default}{A default transformation to use}

\item{...}{Additional specific transformations either named by the geom
(e.g. \code{bar}, or by its position in the layer stack, e.g. \code{"2"})}

\item{name}{A name for the manual modification (only used when printing the
object)}

\item{early}{Should the data appear in the beginning of the transition or in
the end}

\item{alpha}{The start/end transparency.}

\item{size}{The proportional start/end size. \code{0} means complete shrinking
while \code{1} means no shrinking}

\item{colour, color, fill}{The start/end colour and fill the elements should
(dis)appear into}

\item{x_loc, y_loc}{Start and end positions of the graphic elements}

\item{x_mod, y_mod}{Modification to add to the entering or exiting data}
}
\description{
The purpose of \code{enter_*()} and \code{exit_*()} is to control what happens with
data that does not persist during a tween. In general the non-persistent data
is transformed to an \emph{invisible} version that can be tweened to, e.g. by
setting the opacity to 0 or be moving the element off-screen. It is possible
to define your own transformations, or rely on some of the build in
\emph{effects}.
}
\section{User-defined transformations}{

All enter/exit functions allows the user to add additional transformation
functions targeting specific layers. If the functions are named, then the
name is understood to reference the class of geoms it applies to. If the
functions are unnamed or numbered they will apply to the layer with a
matching index in the stack. Named and indexed transformations cannot be
mixed.

All modifications except \code{enter_manual()}/\code{exit_manual()} sets a range of
modifications already, but further can be added with the \code{...}. For the
manual versions a \code{default} transformation can be set which will apply to all
layers that does not match any of the other given transformations. Often a
single default transformation is enough and no specific transformations are
needed.

Transformation can be given as any expression that can be converted with
\code{\link[rlang:as_function]{rlang::as_function()}}. This means that \code{purrr} style lambda functions are
allowed in addition to anonymous functions etc. Transformation functions must
accept a data.frame and return a data.frame of the same dimensions. The
function will be called with the entering/exiting layer data, except for the
case of polygon- and path-like layers in which case the function recieves the
entering/exiting polygon/path data one by one. A special option is to set a
transformation as \code{NULL} instead of a function. In that case the entering and
exiting data will simply appear/disappear when it is no longer part of a
frame.
}

\section{Modification composition}{

Enter and exit modifications are composable so that multiple different ones
can be added to an animation and will be applied in turn. You can also
combine multiples and save them as a new enter or exit modification using
\code{c()}.

Due to the composable nature of enter and exit modifications it is not
possible to overwrite a prior modification by adding a new. If it is needed
to start from scratch then the sentinels \code{enter_reset()} and \code{exit_reset()}
are provided which clears all prior modifications.
}

\section{Modification types}{

A range of modification types are provided by \code{gganimate} and using
\code{enter_manual()}/\code{exit_manual()} or modification composition it is possible
to create your own.

\strong{appear}/\strong{disappear} will simply make elements appear/disappear at either
the start or end of the transition. The default if nothing else is added.

\strong{fade} will simply set the alpha value to zero making the elements fade
in/out during the transition.

\strong{grow}/\strong{shrink} will set the elements to zero size making them gradually
grow into / shrink out of existence. Zero size depends on the type of layer,
e.g. polygons/paths will have all their points set to the mean, while points
will have size/stroke set to zero.

\strong{recolour}/\strong{recolor} will change the colour and/or fill of the elements
making them gradually change from the defined colour and into their try
colour. Be aware that unless the colour and fill are set to the same as the
background colour of the plot this modification needs to be combined with
others to ensure that elements does not abruptly appear.

\strong{fly} will set a specific x and y position where all elements will enter
from/ exit to, irrespectible of their real position.

\strong{drift} will modify the real position of the entering and exiting elements
by a specified amount, e.g. setting \code{x_mod = -5} will let all elements enter
from/exit to the left with a terminal position 5 points to the left of the
real position.
}

\examples{
# Default is appear/disappear
anim <- ggplot(mtcars, aes(factor(gear), mpg)) +
  geom_boxplot() +
  transition_states(gear, 2, 1)

# Fade-in, fly-out
anim1 <- anim +
  enter_fade() +
  exit_fly(x_loc = 7, y_loc = 40)

# Enter and exit accumulates
anim2 <- anim +
  enter_fade() + enter_grow() +
  exit_fly(x_loc = 7, y_loc = 40) + exit_recolour(fill = 'forestgreen')

}
