#' D3 palette reordered.
#'
#' @description A function to retreive a vector of hex codes for a non-numeric (or non-ordererd) variable.
#'
#' @param n The number of colours (excluding an NA colour).
#'
#' @return A character vector of hex codes.
#' @export
#' @examples
#' scales::show_col(pal_default(9))
#' @references
#' https://blog.datawrapper.de/colors-for-data-vis-style-guides/
pal_default <- function(n) {

  if (n > 5) rlang::warn("The default ggblanket only has 5 colours")

  if (n == 1) {
    "#2B6999"
  }

  else {
    c("#53B0AE", "#A31414", "#B2C615", "#E37000", "#2B6999")[1:n]
  }
}

#' NA palette.
#'
#' @description A function to retreive a hex code for a colour to use for NA values.
#'
#' @param pal The hex code or name of the NA colour. Defaults to "#88837D".
#'
#' @return A character vector.
#' @export
#' @examples
#' scales::show_col(pal_na_default())
#' @references
#' https://blog.datawrapper.de/colors-for-data-vis-style-guides/
pal_na_default <- function(pal = "#88837D") {
  return(pal)
}
