% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.R
\name{aes_colour_darken}
\alias{aes_colour_darken}
\alias{aes_colour_lighten}
\alias{aes_fill_darken}
\alias{aes_fill_lighten}
\title{Lighten/darken a colour/fill aesthetic}
\usage{
aes_colour_darken(..., amount = 0.1)

aes_colour_lighten(..., amount = 0.1)

aes_fill_darken(..., amount = 0.1)

aes_fill_lighten(..., amount = 0.1)
}
\arguments{
\item{...}{Other arguments passed to \code{\link[colorspace:lighten]{colorspace::darken()}}/\code{\link[colorspace:lighten]{colorspace::lighten()}}.}

\item{amount}{Numeric specifying the amount of lightening or darkening.}
}
\value{
A ggplot2 aesthetic
}
\description{
Lighten/darken a colour/fill aesthetic based on a
\itemize{
\item \code{aes_colour_darken()} Darken a colour aesthetic, relative to a fill aesthetic
\item \code{aes_colour_lighten()} Lighten a colour aesthetic, relative to the fill aesthetic
\item \code{aes_fill_darken()} Darken a fill aesthetic, relative to a colour aesthetic
\item \code{aes_fill_lighten()} Lighten a fill aesthetic, relative to the colour aesthetic
Can be spliced into \link[ggplot2:aes]{ggplot2::aes} with \link[rlang:splice-operator]{rlang::!!!}.
}
}
\examples{
library(ggblanket)
library(ggplot2)
library(palmerpenguins)

set_blanket(
  alpha_recursive = 1,
)

penguins |>
  gg_bar(
    y = species,
    col = island,
    mapping = aes_colour_darken(amount = 0.2),
    width = 0.75,
  )

penguins |>
gg_bar(
  y = species,
  col = island,
  mapping = aes(!!!aes_colour_darken(amount = 0.2)),
  width = 0.75,
)

}
