% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weave.R
\name{weave_reference_defaults}
\alias{weave_reference_defaults}
\title{Set reference-line geom defaults}
\usage{
weave_reference_defaults(..., colour = "#121B24FF", linewidth = 0.25)
}
\arguments{
\item{...}{Provided to require argument naming, support trailing commas etc.}

\item{colour}{A hex code.}

\item{linewidth}{A linewidth.}
}
\description{
Update the "abline", "hline" and "vline" geom defaults.
}
\examples{
library(ggplot2)
library(dplyr)
library(palmerpenguins)

set_blanket(theme = dark_mode_r())
weave_font_defaults(colour = darkness[1])
weave_reference_defaults(colour = darkness[1])

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    x_breaks_n = 4,
  ) +
  geom_vline(xintercept = 200) +
  annotate("text", x = I(0.25), y = I(0.75), label = "Here")

}
