% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_font_defaults}
\alias{set_font_defaults}
\title{Set the font geom defaults}
\usage{
set_font_defaults(
  ...,
  colour = "#121B24FF",
  fill = "#FFFFFFFF",
  size = 11/2.835052,
  family = ""
)
}
\arguments{
\item{...}{Provided to require argument naming, support trailing commas etc.}

\item{colour}{A hex code.}

\item{fill}{A hex code.}

\item{size}{A size.}

\item{family}{A family.}
}
\description{
Update the "text" and "label" geom defaults. Note all other text is controlled by the theme.
}
\examples{
library(ggplot2)
library(dplyr)
library(palmerpenguins)

set_blanket(theme = dark_mode_r())
set_font_defaults(colour = darkness[1])
set_reference_defaults(colour = darkness[1])

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    x_breaks_n = 4,
  ) +
  geom_vline(xintercept = 200) +
  annotate("text", x = I(0.25), y = I(0.75), label = "Here")

}
