% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes_contrast.R
\name{aes_contrast}
\alias{aes_contrast}
\title{An auto-contrast colour aesthetic}
\usage{
aes_contrast(mode_family = "light", dark = NULL, light = NULL)
}
\arguments{
\item{mode_family}{The mode family to optimise light and dark colours for. Options are "light", "grey" or "dark".}

\item{dark}{A dark colour. If NULL, uses \code{mode_family} optimised colour.}

\item{light}{A light colour. If NULL, uses \code{mode_family} optimised colour.}
}
\value{
An aesthetic
}
\description{
A colour aesthetic for annotation that automatically contrasts with fill. Can be spliced into \link[ggplot2:aes]{ggplot2::aes} with \link[rlang:splice-operator]{rlang::!!!}.
}
\examples{
library(ggplot2)
library(dplyr)
library(stringr)
library(palmerpenguins)

set_blanket()

penguins |>
  count(species, sex) |>
  gg_col(
    x = sex,
    y = n,
    col = species,
    label = n,
    position = position_dodge2(preserve = "single"),
    width = 0.75,
    x_labels = \(x) str_to_sentence(x),
  ) +
  geom_text(
    mapping = aes_contrast(),
    # mapping = aes(!!!aes_contrast()),
    position = position_dodge2(width = 0.75, preserve = "single"),
    vjust = 1.33,
    show.legend = FALSE,
  )

penguins |>
  count(species, sex) |>
  gg_col(
    x = sex,
    y = n,
    col = species,
    label = n,
    position = position_dodge2(preserve = "single"),
    width = 0.75,
    x_labels = \(x) str_to_sentence(x),
    mode = dark_mode_r(),
  ) +
  geom_text(
    mapping = aes_contrast("dark"),
    #' mapping = aes(!!!aes_contrast("dark")),
    position = position_dodge2(width = 0.75, preserve = "single"),
    vjust = 1.33,
    show.legend = FALSE,
  )
}
