% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggeffect.R
\name{ggeffect}
\alias{ggeffect}
\alias{eff}
\title{Get marginal effects from model terms}
\usage{
ggeffect(model, terms, ci.lvl = 0.95, ...)

eff(model, terms, ci.lvl = 0.95, ...)
}
\arguments{
\item{model}{A fitted model object, or a list of model objects. Any model
that is supported by the \CRANpkg{effects}-package should work.}

\item{terms}{Character vector with the names of those terms from \code{model},
for which marginal effects should be displayed. At least one term
is required to calculate effects, maximum length is three terms,
where the second and third term indicate the groups, i.e. predictions
of first term are grouped by the levels of the second (and third)
term. Indicating levels in square brackets allows for selecting
only specific groups. Term name and levels in brackets must be
separated by a whitespace character, e.g.
\code{terms = c("age", "education [1,3]")}. See 'Examples'.
All remaining covariates that are not specified in \code{terms}
are held constant (if \code{full.data = FALSE}, the default)
or are set to the values from the observations (i.e. are kept
as they happen to be; see 'Details').}

\item{ci.lvl}{Numeric, the level of the confidence intervals. For \code{ggpredict()},
use \code{ci.lvl = NA}, if confidence intervals should not be calculated
(for instance, due to computation time).}

\item{...}{Further arguments passed down to \code{\link[effects]{Effect}}.}
}
\value{
A tibble (with \code{ggeffects} class attribute) with consistent data columns:
        \describe{
          \item{\code{x}}{the values of the model predictor to which the effect pertains, used as x-position in plots.}
          \item{\code{predicted}}{the predicted values, used as y-position in plots.}
          \item{\code{conf.low}}{the lower bound of the confidence interval for the predicted values.}
          \item{\code{conf.high}}{the upper bound of the confidence interval for the predicted values.}
          \item{\code{group}}{the grouping level from the second term in \code{terms}, used as grouping-aesthetics in plots.}
          \item{\code{facet}}{the grouping level from the third term in \code{terms}, used to indicate facets in plots.}
        }
}
\description{
\code{ggeffect()} computes marginal effects of model terms.
               It internally calls \code{\link[effects]{Effect}} and
               puts the result into tidy data frames.
               \code{eff()} is an alias for \code{ggeffect()}
}
\note{
The results of \code{ggeffect()} and \code{ggpredict()} are usually (almost)
      identical. It's just that \code{ggpredict()} calls \code{predict()}, while
      \code{ggeffect()} calls \code{\link[effects]{Effect}} to compute marginal
      effects at the mean.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
ggeffect(fit, terms = "c12hour")

mydf <- ggeffect(fit, terms = c("c12hour", "c161sex"))
plot(mydf)

}
