% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conveniences.R
\name{distribute_args}
\alias{distribute_args}
\alias{elem_list_text}
\alias{elem_list_rect}
\title{Element list constructors}
\usage{
distribute_args(..., .fun = element_text, .cull = TRUE)

elem_list_text(...)

elem_list_rect(...)
}
\arguments{
\item{...}{Vectorised arguments to pass on to functions.}

\item{.fun}{A function to distribute arguments to.}

\item{.cull}{A \code{logical(1)} determining if unknown arguments are being
culled.}
}
\value{
A \code{list} of outputs from \code{fun}.
}
\description{
These functions take a vector of arguments and pass on the
\ifelse{html}{\out{i<sup>th</sup>}}{\eqn{i^{th}}} item of the vector to an
\ifelse{html}{\out{i<sup>th</sup>}}{\eqn{i^{th}}} call of a function. The
\code{elem_list_text} and \code{elem_list_rect} are convenience functions for
constructing lists of \code{\link[ggplot2:element]{element_text()}} and
\code{\link[ggplot2:element]{element_rect()}} theme elements.
}
\details{
\code{NA}s and \code{NULL}s will be silently dropped. If you want to pass on a
transparent \code{fill} or \code{colour} argument, you should use the more verbose
character \code{"transparent"} instead. However, you \emph{can} use a \code{NA} to
indicate that it's argument should not be passed to a function in that
position.
}
\note{
Whereas the \code{distribute_args} function might seem amenable for
off-label uses elsewhere (besides constructing lists of theme elements), it
is not intended as such. For example, because valid arguments will be
deduced from the formals of a function, using certain functions can be
troublesome. For example, the \code{distribute_args} function does not properly
recognise the utility of a \code{...} argument in a function that it is supposed
to distribute arguments to. This can be a problem for object-oriented
functions: if the methods contain more arguments than the generic itself,
these extra arguments will be silently dropped.
}
\examples{
# Providing arguments for `element_rect()`
elem_list_rect(
  # The first element_rect will have linetype 1, the second gets 3
  linetype = c(1, 3),
  # If an argument doesn't exist, it will be silently dropped
  nonsense_argument = c("I", "will", "be", "filtered", "out")
)

# Providing arguments for `element_text()`
elem_list_text(
  # `NA`s will be skipped
  family = c("mono", NA, "sans"),
  # Providing a list of more complex arguments. `NULL` will be skipped too.
  margin = list(NULL, margin(t = 5))
)

# Providing arguments to other functions
distribute_args(
  lineend = c("round", "butt", "square"),
  # If you want to pass a vector instead of a scalar, you can use a list
  colour = list(c("blue", "red"), "green"),
  .fun = element_line
)
}
\seealso{
The \code{\link[ggplot2:element]{element_text()}} and
\code{\link[ggplot2:element]{element_rect()}} theme elements for a
description of their arguments.
}
