% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_source_sans_3.R
\name{load_source_sans_3}
\alias{load_source_sans_3}
\title{Load and use Source Sans 3}
\usage{
load_source_sans_3()
}
\value{
Nothing, run for side effect of loading the font and activating
showtext.
}
\description{
Simple wrapper for \code{sysfonts::font_add_google()} and
\code{showtext::showtext_auto()} to load the
\href{https://fonts.google.com/specimen/Source+Sans+3}{Source Sans 3 font} and
specify all plots to automatically use showtext. Use to load the default
font family for \code{\link[=geom_text_hdx]{geom_text_hdx()}} and \code{\link[=geom_label_hdx]{geom_label_hdx()}}.
}
\examples{
library(ggplot2)
p <- ggplot(
  data = mtcars,
  mapping = aes(
    x = mpg,
    y = mpg,
    label = rownames(mtcars)
  )
)

# font not loaded so error will be generated
try(p + geom_label_hdx())

load_source_sans_3()

p + geom_label_hdx()

}
\seealso{
\code{\link[=gghdx]{gghdx()}} for automatically running \code{load_source_sans_3()},
along with other styling.
}
