% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{opts_selection}
\alias{opts_selection}
\title{selection effect settings}
\usage{
opts_selection(css = NULL, type = "multiple", only_shiny = TRUE)
}
\arguments{
\item{css}{css to associate with elements when they are selected.}

\item{type}{selection mode ("single", "multiple", "none")
when widget is in a Shiny application.}

\item{only_shiny}{disable selections if not in a shiny context.}
}
\description{
Allows customization of the rendering of
selected graphic elements.
}
\examples{
library(ggplot2)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg <- ggplot(
  data = dataset,
  mapping = aes(x = wt, y = qsec, color = disp,
                tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg)
x <- girafe_options(x,
  opts_selection(type = "multiple",
    css = "fill:red;stroke:gray;r:5pt;") )
if( interactive() ) print(x)
}
\seealso{
set options with \code{\link{girafe_options}}

Other girafe animation options: \code{\link{opts_hover}},
  \code{\link{opts_toolbar}}, \code{\link{opts_tooltip}},
  \code{\link{opts_zoom}}
}
\concept{girafe animation options}
