% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labeller_interactive.R
\name{labeller_interactive}
\alias{labeller_interactive}
\title{Create a interactive strip label}
\usage{
labeller_interactive(
  custom_label_func = id_label,
  ...,
  .default = ggplot2::label_value
)
}
\arguments{
\item{custom_label_func}{a function that returns the result
of \code{\link[=label_interactive]{label_interactive()}}.}

\item{...}{optional additional arguments for function \code{custom_label_func}.}

\item{.default}{a Labeller function, see \code{\link[=label_value]{label_value()}}}
}
\description{
These function is an helper function
to let user add interactivity on facet strip text.

The function adds interactive attributes but does not tell
to use them, make sure the theme you are using is specifying the use of \code{element_text_interactive}
for strip text,
for example \code{theme(strip.text = element_text_interactive())}
}
\examples{
library(ggplot2)
library(ggiraph)

gg_jitter <- ggplot(
  mpg, aes(cyl, hwy, group = cyl)) +
  geom_boxplot() +
  facet_wrap(~manufacturer,
             labeller = labeller_interactive(id_label)) +
  theme(strip.text = element_text_interactive())

x <- girafe(ggobj = gg_jitter)
if(interactive()) print(x)


lab_custom <- function(z, prefix = "label: ") {
  label_interactive(label = z, data_id = z, tooltip = paste0(prefix, z))
}

gg_jitter <- ggplot(diamonds, aes(x = x)) +
  geom_density() +
  facet_grid(color ~ cut,
    labeller = labeller(
      cut = labeller_interactive(lab_custom, prefix = "cut: "),
      color = labeller_interactive(lab_custom, prefix = "color: ")
    )) +
  theme_light() +
  theme(
    strip.text.x = element_text_interactive(),
    strip.text.y = element_text_interactive()
  )

x <- girafe(ggobj = gg_jitter, width_svg = 8, height_svg = 5)

if (interactive()) print(x)
}
\seealso{
\code{\link[=id_label]{id_label()}}, \code{\link[=label_interactive]{label_interactive()}}
}
