% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_hex_interactive.R
\name{geom_hex_interactive}
\alias{geom_hex_interactive}
\title{Create interactive hexagonal heatmaps}
\usage{
geom_hex_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggplot2:geom_hex]{ggplot2::geom_hex()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive hexagonal heatmaps to a ggplot -------
library(ggplot2)
library(ggiraph)

p <- ggplot(diamonds, aes(carat, price)) +
  geom_hex_interactive(aes(tooltip = after_stat(count)), bins = 10)
x <- girafe(ggobj = p)
if( interactive() ) print(x)
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
