% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggBoxplot.R
\name{ggBoxplot}
\alias{ggBoxplot}
\title{Draw boxplots of a data.frame}
\usage{
ggBoxplot(data, mapping = NULL, rescale = FALSE, horizontal = FALSE,
  interactive = FALSE, addMean = TRUE, position = 0.9, use.label = TRUE,
  use.labels = TRUE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{rescale}{if true, rescale the data.frame}

\item{horizontal}{if true, horizontal boxplots will be made}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{addMean}{Whether add mean point on the plot}

\item{position}{An integer. Uses as argument of position_dodge()}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{...}{other arguments passed on to geom_boxplot_interactive}
}
\description{
Draw boxplots of a data.frame
}
\examples{
require(ggplot2)
require(ggiraph)
require(reshape2)
ggBoxplot(mtcars,rescale=TRUE)
ggBoxplot(mtcars,aes(x=c(mpg,cyl,disp,hp,drat),color=am),rescale=TRUE)
ggBoxplot(mtcars,aes(x=c(mpg,cyl,disp,hp,drat)),rescale=TRUE)
ggBoxplot(mtcars,rescale=TRUE,interactive=TRUE)
ggBoxplot(mtcars,horizontal=TRUE,interactive=TRUE)
}
