% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggDot.R
\name{ggDot}
\alias{ggDot}
\title{Draw a Wilkinson dot plot}
\usage{
ggDot(data, mapping, stackdir = "center", binaxis = "y", binwidth = 0.5,
  method = "dotdensity", position = 0.2, boxwidth = 0.25,
  boxfill = NULL, use.label = TRUE, use.labels = TRUE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{stackdir}{which direction to stack the dots. "up" (default), "down", "center", "centerwhole" (centered, but with dots aligned)}

\item{binaxis}{The axis to bin along, "x" (default) or "y"}

\item{binwidth}{When method is "dotdensity", this specifies maximum bin width. When method is "histodot", this specifies bin width. Defaults to 1/30 of the range of the data}

\item{method}{"dotdensity" (default) for dot-density binning, or "histodot" for fixed bin widths (like stat_bin)}

\item{position}{Position adjustment. If 0, no adjustment.}

\item{boxwidth}{The width of boxplot}

\item{boxfill}{Fill color of boxplot}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{...}{other arguments passed on to geom_dotplot}
}
\description{
Draw a Wilkinson dot plot
}
\examples{
require(ggplot2)
if(requireNamespace("gcookbook",quietly=TRUE)){ # for data heightweight
 require(gcookbook)
 ggDot(heightweight,aes(sex,heightIn,fill=sex),boxfill="white",binwidth=0.4)
 ggDot(heightweight,aes(heightIn))
 ggDot(heightweight,aes(x=heightIn,fill=sex))
}
require(moonBook) #for use data radial
ggDot(radial,aes(x=sex,y=height,fill=sex),boxfill="white",position=0,binwidth=1,boxwidth=1)
ggDot(radial,aes(x=height,fill=sex),binwidth=1)
ggDot(acs,aes(x=sex,y=age,color=sex))
ggDot(acs,aes(x=Dx,y=age,color=Dx))
}
