% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_sf_inset.R
\docType{data}
\name{geom_sf_inset}
\alias{geom_sf_inset}
\alias{GeomSfInset}
\title{Visualise sf objects with insets}
\usage{
geom_sf_inset(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf",
  position = "identity",
  ...,
  inset = NULL,
  inset_copy = TRUE,
  inset_clip = FALSE,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.}

\item{inset_copy}{Draw both the base layers and the inset layers using the same
configuration. Only relevant when \code{inset} is specified.}

\item{inset_clip}{When an inset is drawn, place included points only in the inset.}
}
\value{
A ggplot layer similar to \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} but transformed according to the
inset configuration.
}
\description{
This is a wrapper around \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} that assists with creating map
insets.
}
\details{
First, configure an inset using \code{\link[=configure_inset]{configure_inset()}}, then pass the
configuration object to each applicable layer using the \code{inset}
parameter.

After specifying all your usual geoms, use \code{\link[=geom_inset_frame]{geom_inset_frame()}} to add a frame
around the inset that connects it to the main map.

Internally this works by inserting duplicates of the \code{geom_sf()} layers
where the duplicates have been transformed and cropped to fit into the inset.
The way that this copying works can be controlled with the \code{inset_copy}
parameter if for example you'd like a different aesthetic mapping for the
copy that goes in the inset. The default copies the layers:

\if{html}{\out{<div class="sourceCode">}}\preformatted{geom_sf_inset(aes(...), inset = inset_cfg, ...)
}\if{html}{\out{</div>}}

but this version specifies them separately:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# aesthetics for main map only:
geom_sf(aes(...), ...)
# aesthetics for inset map only:
geom_sf_inset(aes(...), inset = inset_cfg, inset_copy = FALSE, ...)
}\if{html}{\out{</div>}}
}
\examples{
library(sf)
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
cfg <- configure_inset(
  centre = st_sfc(st_point(c(-82, 35)), crs = 4326),
  scale = 2,
  translation = c(10, -60),
  radius = 50,
  units = "mi")

ggplot(nc) + geom_sf_inset(aes(fill = AREA), inset = cfg) + coord_sf()
}
\keyword{datasets}
