% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_Rhat.R
\name{ggs_Rhat}
\alias{ggs_Rhat}
\title{Dotplot of Potential Scale Reduction Factor (Rhat)}
\usage{
ggs_Rhat(D, family = NA, scaling = 1.5, greek = FALSE)
}
\arguments{
\item{D}{Data frame whith the simulations}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{scaling}{Value of the upper limit for the x-axis. By default, it is 1.5, to help contextualization of the convergence. When 0 or NA, the axis are not scaled.}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a dotplot of Potential Scale Reduction Factor (Rhat), proposed by Gelman and Rubin (1992). The version from the second edition of Bayesian Data Analysis (Gelman, Carlin, Stein and Rubin) is used.
}
\details{
Notice that at least two chains are required.
}
\examples{
data(linear)
ggs_Rhat(ggs(s))
}

