% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_compare_partial.R
\name{ggs_compare_partial}
\alias{ggs_compare_partial}
\title{Density plots comparing the distribution of the whole chain with only its last part.}
\usage{
ggs_compare_partial(D, family = NA, partial = 0.1, rug = FALSE, greek = FALSE)
}
\arguments{
\item{D}{Data frame whith the simulations}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{partial}{Percentage of the chain to compare to. Defaults to the last 10 percent.}

\item{rug}{Logical indicating whether a rug must be added to the plot. It is FALSE by default, since in large chains it may use lot of resources and it is not central to the plot.}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}
}
\value{
A \code{ggplot} object.
}
\description{
Density plots comparing the distribution of the whole chain with only its last part.
}
\examples{
data(linear)
ggs_compare_partial(ggs(s))
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09
}
