% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{binary}
\alias{binary}
\title{Simulated data for a binary logistic regression and its MCMC samples}
\format{
Two objects, namely:
\describe{
  \item{s.binary}{A coda object containing posterior distributions of the intercept (theta[1]) and slope (theta[2]) of a logistic regression with simulated data.}
  \item{y.binary}{A numeric vector containing the observed values of the outcome in the binary regression with simulated data.}
}
}
\source{
Simulated data for ggmcmc
}
\usage{
data(binary)
}
\description{
Simulate a dataset with one explanatory variable and one binary outcome variable using (y ~ dbern(mu); logit(mu) = theta[1] + theta[2] * X). The data loads two objects: the observed y values and the coda object containing simulated values from the posterior distribution of the intercept and slope of a logistic regression. The purpose of the dataset is only to show the possibilities of the ggmcmc package.
}
\examples{
data(binary)
str(s.binary)
str(y.binary)
table(y.binary)
}
\keyword{datasets}
