% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msa_data.R
\name{msa_data}
\alias{msa_data}
\title{msa_data}
\usage{
msa_data(fasta, start = NULL, end = NULL, font = "helvetica_regular",
  color = "Clustal")
}
\arguments{
\item{fasta}{Aligned fasta file.}

\item{start}{Start position to plot,Defaults = NULL.}

\item{end}{End position to plot, Defaults = NULL.}

\item{font}{Character font, Defaults is 'helvetica_regular'.}

\item{color}{A Color scheme. One of 'Clustal', 'Chemistry_AA', 'Shapely_AA', 'Zappo_AA', 'Taylor_AA', 'Chemistry_NT', 'Shapely_NT', 'Zappo_NT', 'Taylor_NT'.Defaults is 'Clustal'.}
}
\value{
A data frame
}
\description{
This function parses FASTA file and convert it to a tidy data frame. 
The function will also assign color to each molecule (amino acid or nucleotide) according to the selected color scheme. Sequence logo data for drawing alignment label will also be added if font != NULL. The output of msa_data() is the input of geom_msa().
}
\examples{
fasta <- system.file("extdata/sample.fasta", package="ggmsa")
data <- msa_data(fasta, 20, 120, font = 'helvetica_regular', color = 'Chemistry_AA' )
}
\author{
guangchuang yu
}
