% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-quantiles.R
\name{geom_quantiles}
\alias{geom_quantiles}
\title{Add quantile layers on serial axes coordinate}
\usage{
geom_quantiles(
  mapping = NULL,
  data = NULL,
  stat = "quantile",
  position = "identity",
  ...,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Use to override the default connection between
\code{geom_quantile} and \code{stat_quantile}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
In \code{ggplot2}, \code{geom_quantile()} is used to fit a quantile regression to the data and draws
the fitted quantiles with lines. However, \code{geom_quantiles()} is mainly used to draw quantile lines
on serial axes. See examples
}
\examples{
p <- ggplot(iris,
            mapping = aes(
              Sepal.Length = Sepal.Length,
              Sepal.Width = Sepal.Width,
              Petal.Length = Petal.Length,
              Petal.Width = Petal.Width
            )
  ) +
  geom_path(alpha = 0.2)  +
  coord_serialaxes(scaling = "none")
p + geom_quantiles(colour = c("red", "green", "blue"),
                   quantiles = c(0.25, 0.5, 0.75),
                   size = 2)

}
\seealso{
\code{\link{geom_serialaxes_quantile}}
}
