% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qwrap.R
\name{qwrap}
\alias{qwrap}
\title{Quickly wrap data}
\usage{
qwrap(object, ..., .group = NULL)
}
\arguments{
\item{object, }{the object to wrap}

\item{..., }{named formulas with the form \code{from ~ to} (see examples)}

\item{.group}{optional group column (see \link{wrap})}
}
\description{
Wraps periodic data from one specified range to the other in one line.
}
\details{
\code{qwrap} is a shortcut to \code{wrap(periodic(obejct, x = range_from), x = range_to)}
}
\examples{
x <- seq(0, 360 - 20, by = 20)
df <- data.frame(x = x, y = cos(x*pi/180))
qwrap(df, x = c(0, 360) ~ c(-180, 180))

}
