% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom.R
\name{stat_fit_glance}
\alias{stat_fit_glance}
\title{One row summary data frame for a fitted model}
\usage{
stat_fit_glance(mapping = NULL, data = NULL, geom = "text_npc",
  method = "lm", method.args = list(formula = y ~ x),
  label.x = "left", label.y = "top", hstep = 0, vstep = NULL,
  position = "identity", na.rm = FALSE, show.legend = FALSE,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character.}

\item{method.args}{list of arguments to pass to \code{method}.}

\item{label.x, label.y}{\code{numeric} with range 0..1 "normalized parent
coordinates" (npc units) or character if using \code{geom_text_npc()} or
\code{geom_label_npc()}. If using \code{geom_text()} or \code{geom_label()}
numeric in native data units. If too short they will be recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_fit_glance} fits a model and returns a summary
  "glance" of the model's statistics, using package 'broom'.
}
\note{
The names of the columns in the returned data are consitent with those
  returned by method \code{glance()} from package 'broom', that will
  frequently differ from the name of values returned by the print methods
  corresponding to fit or test function used. With some methods like
  \code{cor.test()} the data embedded in the \code{"ggplot"} object cannot be
  automatically passed as argument for the \code{data} parameter of the test
  or model fit function.
}
\section{Computed variables}{
 The output of \code{\link[broom]{glance}} is
  returned as is in the \code{data} object. If you do not know what names
  to expect for the variables returned, use \code{broom::glance()} and
  \code{names()} or \code{print()} to find out.
}

\section{Warning!}{
 The current implementation works only with methods that
  accept a formula as argument and which have a \code{data} paremeter through
  which a data frame can be passed. For example, \code{lm()} should be
  used with the formula interface, as the evaluation of \code{x} and \code{y}
  needs to be delayed until the internal \code{object} of the ggplot is
  available.

 \code{stat_fit_glance} applies the function given by
  \code{method} separately to each group of observations, and factors mapped
  to aesthetics generate a separate group for each factor level. Because of
  this, it is not useful for annotating plots with results from
  \code{t.test()} or ANOVA or ANCOVA. In such cases use the
  \code{stat_fit_tb()} statistic which does the model fitting per panel.
}

\examples{
# Regression example
my.df <-
  data.frame(X = c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1),
             Y = c( 2.6,  3.1,  2.5,  5.0,  3.6,  4.0,  5.2,  2.8,  3.8))
# We need to check the names of the returned values!
broom::glance(lm(formula = Y ~ X, data = my.df ))
ggplot(my.df, aes(X, Y)) +
  geom_point() +
  stat_fit_glance(method = "lm",
                  method.args = list(formula = y ~ x),
                  aes(label = sprintf('r^2~"="~\%.3f~~italic(P)~"="~\%.2f',
                      stat(r.squared), stat(p.value))),
                  parse = TRUE)

}
