% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom.R
\name{stat_fit_tidy}
\alias{stat_fit_tidy}
\title{One row data frame with fitted parameter estimates}
\usage{
stat_fit_tidy(mapping = NULL, data = NULL, geom = "text_npc",
  method = "lm", method.args = list(formula = y ~ x),
  label.x = "left", label.y = "top", hstep = 0, vstep = NULL,
  position = "identity", na.rm = FALSE, show.legend = FALSE,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character.}

\item{method.args}{list of arguments to pass to \code{method}.}

\item{label.x, label.y}{\code{numeric} with range 0..1 or character.
Coordinates to be used for positioning the output, expressed in "normalized
parent coordinates" or character string. If too short they will be recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_fit_tidy} fits a model and returns a "tidy" version
  of the model's summary, using package 'broom'. To add the summary in
  tabular form use \code{\link{stat_fit_tb}}. When using
  \code{stat_fit_tidy()} you will most likely want to change the default
  mapping for label.
}
\section{Computed variables}{
 The output of \code{\link[broom]{tidy}} is
  returned after reshaping it into a single row. Grouping is respected, and
  the model fit separatately to each group of data. The returned \code{data}
  object has one row for each group within a panel.
}

\examples{

# Regression example
my.df <-
  data.frame(X = c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1),
             Y = c( 2.6,  3.1,  2.5,  5.0,  3.6,  4.0,  5.2,  2.8,  3.8))

ggplot(my.df, aes(X, Y)) +
  geom_point() +
  stat_fit_tidy(method = "lm",
                method.args = list(formula = y ~ x),
                mapping = aes(label = sprintf("Slope = \%.3g\\np-value = \%.3g",
                                              stat(x_estimate), stat(x_p.value))))

}
