% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmodel2-util.R
\name{confint.lmodel2}
\alias{confint.lmodel2}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{lmodel2}(object, parm, level = 0.95, method = "MA", ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing, all
parameters are considered.}

\item{level}{the confidence level required. Currently only 0.95 accepted.}

\item{method}{character One of the methods available in \code{object}.}

\item{...}{ignored by this method.}
}
\value{
A data frame with two rows and three columns.
}
\description{
Computes confidence intervals for one or more parameters in a fitted model.
This a method for objects inheriting from class "lmodel2".
}
\details{
Function \code{lmodel2()} from package 'lmodel2' returns a fitted
  model object of class \code{"lmodel2"} which differs from that returned by
  \code{lm()}. Here we implement a \code{confint()} method for objects of
  this class. It differs from the generic method and that for lm objects in
  having an additional formal parameter \code{method} that must be used to
  select estimates based on which of the methods supported by
  \code{lmodel2()} are to be extracted. The returned object is identical in
  its structure to that returned by \code{confint.lm()}.
}
\seealso{
\code{\link[lmodel2]{lmodel2}}
}
